/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.About;
import gui.Edit;
import gui.Find;
import gui.Main;
import gui.Move;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import samyedit.AirCableChannel;
import samyedit.AirChannel;
import samyedit.Channel;
import samyedit.MapParser;
import samyedit.SatChannel;
import samyedit.SkyFeedChannels;
import samyedit.Zip;

class MySelListener
implements SelectionListener {
    public static final int ACTION_NEWAIR = 10;
    public static final int ACTION_NEWCABLE = 11;
    public static final int ACTION_NEWSAT = 12;
    public static final int ACTION_OPEN = 20;
    public static final int ACTION_OPEN_SCM = 21;
    public static final int ACTION_SAVE = 22;
    public static final int ACTION_SAVEAS = 23;
    public static final int ACTION_SAVE_SCM = 24;
    public static final int ACTION_SAVE_SCM_AS = 25;
    public static final int ACTION_ADDCHAN = 36;
    public static final int ACTION_EDITCHAN = 37;
    public static final int ACTION_MOVECHAN = 38;
    public static final int ACTION_DELETE = 39;
    public static final int ACTION_FINDCHAN = 40;
    public static final int ACTION_FAVADD = 41;
    public static final int ACTION_FAVDEL = 42;
    public static final int ACTION_LOCKADD = 43;
    public static final int ACTION_LOCKDEL = 44;
    public static final int ACTION_SKY = 45;
    public static final int ACTION_FAV79_1 = 64;
    public static final int ACTION_FAV79_2 = 65;
    public static final int ACTION_FAV79_3 = 66;
    public static final int ACTION_FAV79_4 = 67;
    public static final int ACTION_WWW = 127;
    public static final int ACTION_FORUM = 128;
    public static final int ACTION_ABOUT = 129;
    private Shell shell;

    MySelListener(Shell shell) {
        this.shell = shell;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        String[] mapOrAll = new String[]{"*map-*D", "*.*"};
        String[] scmOrAll = new String[]{"*.scm", "*.*"};
        String[] allFiles = new String[]{"*map-*D", "*.scm", "*.*"};
        String spath = null;
        if (e.widget instanceof MenuItem) {
            int action = (Integer)e.widget.getData("action");
            switch (action) {
                case 10: {
                    Main.mapType = (byte)2;
                    Main.channelList.clear();
                    Main.refresh();
                    Main.deleteColumns();
                    Main.createColumnsAir();
                    break;
                }
                case 11: {
                    Main.mapType = 1;
                    Main.channelList.clear();
                    Main.refresh();
                    Main.deleteColumns();
                    Main.createColumnsCable();
                    break;
                }
                case 12: {
                    Main.mapType = (byte)4;
                    Main.channelList.clear();
                    Main.refresh();
                    Main.deleteColumns();
                    Main.createColumnsSat();
                    break;
                }
                case 21: {
                    String path = null;
                    path = Main.currentDir.getAbsolutePath();
                    path = this.selectFileToOpen("Open SCM File", scmOrAll, path);
                    if (path == null) {
                        Main.statusUpdate(1, "Open SCM: No File selected!");
                        return;
                    }
                    if (Main.extractScm(path) <= 0) {
                        Main.statusUpdate(1, "Open SCM: Extraction of file: " + path + " failed!");
                        return;
                    }
                    Main.statusUpdate(1, "Open: Successful extraction of file: " + path);
                }
                case 20: {
                    String path;
                    if (Main.scmFile == null) {
                        path = null;
                        path = Main.currentDir.getAbsolutePath();
                    } else {
                        path = Main.tempDir;
                    }
                    path = this.selectFileToOpen("Open File", allFiles, path);
                    if (path == null) {
                        Main.statusUpdate(1, "Open: No File selected!");
                        return;
                    }
                    if (path.endsWith(".scm")) {
                        if (Main.extractScm(path) <= 0) {
                            Main.statusUpdate(1, "Open: Extraction of file: " + path + " failed!");
                            return;
                        }
                        Main.statusUpdate(1, "Open: Successful extraction of file: " + path);
                        path = this.selectFileToSave("Open Channel File", mapOrAll, Main.tempDir);
                        if (path == null) {
                            Main.statusUpdate(1, "Open: No Channel-File selected!");
                            return;
                        }
                    }
                    Main.channelList.clear();
                    System.gc();
                    new MapParser(path, Main.channelList);
                    Main.refresh();
                    Main.chanFile = path;
                    Main.statusUpdate(1, "Finished opening file: " + Main.chanFile);
                    return;
                }
                case 23: {
                    spath = this.selectFileToSave("Save File as", allFiles, Main.tempDir);
                    if (spath == null) {
                        return;
                    }
                    MapParser.write(spath, Main.channelList);
                    Main.statusUpdate(1, "File saved as: " + spath);
                    return;
                }
                case 22: {
                    if (Main.chanFile == null) {
                        Main.statusUpdate(3, "Nothing to save ... please open a file first!");
                        return;
                    }
                    MapParser.write(Main.chanFile, Main.channelList);
                    Main.statusUpdate(1, "File " + Main.chanFile + " saved.");
                    return;
                }
                case 24: 
                case 25: {
                    String scmPath = null;
                    if (Main.scmFile == null && Main.tempDir == null) {
                        Main.statusUpdate(3, "Nothing to save ... please open a file first!");
                        return;
                    }
                    if (Main.chanFile != null) {
                        MapParser.write(Main.chanFile, Main.channelList);
                        Main.statusUpdate(1, "File " + Main.chanFile + " saved.");
                    }
                    if (Main.scmFile != null) {
                        scmPath = Main.scmFile;
                    }
                    if (scmPath == null || action == 25) {
                        scmPath = this.selectFileToSave("Save SCM as", scmOrAll, scmPath);
                    }
                    if (scmPath == null) {
                        return;
                    }
                    Main.scmFile = scmPath;
                    if (Zip.compress(scmPath, Main.tempDir) < 0) {
                        Main.statusUpdate(1, "scmFile " + Main.scmFile + " not saved!");
                        return;
                    }
                    Main.statusUpdate(1, "SCM-File saved as: " + Main.scmFile);
                    return;
                }
                case 36: {
                    switch (Main.mapType) {
                        case 1: {
                            new Edit(new AirCableChannel());
                            break;
                        }
                        case 2: {
                            new Edit(new AirChannel());
                            break;
                        }
                        case 4: {
                            new Edit(new SatChannel());
                        }
                    }
                    return;
                }
                case 37: {
                    TableItem[] item = Main.table.getSelection();
                    if (item.length > 0) {
                        new Edit((Channel)item[0].getData());
                    }
                    return;
                }
                case 38: {
                    if (Main.getSelected().length == 0) {
                        return;
                    }
                    new Move();
                    return;
                }
                case 39: {
                    Main.deleteChannels(Main.getSelected());
                    Main.refresh(false);
                    return;
                }
                case 40: {
                    new Find();
                    return;
                }
                case 41: {
                    Channel[] addfav = Main.getSelected();
                    int i = 0;
                    while (i < addfav.length) {
                        addfav[i].fav = (byte)(addfav[i].fav | 1);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 42: {
                    Channel[] delfav = Main.getSelected();
                    int i = 0;
                    while (i < delfav.length) {
                        delfav[i].fav = (byte)(delfav[i].fav & 0xFFFFFFFE);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 43: {
                    Channel[] addlock = Main.getSelected();
                    int i = 0;
                    while (i < addlock.length) {
                        addlock[i].lock = (byte)(addlock[i].lock | 1);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 44: {
                    Channel[] dellock = Main.getSelected();
                    int i = 0;
                    while (i < dellock.length) {
                        dellock[i].lock = (byte)(dellock[i].lock & 0xFFFFFFFE);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 45: {
                    SkyFeedChannels.add(Main.channelList);
                    Main.refresh();
                    return;
                }
                case 64: {
                    Channel[] fav791 = Main.getSelected();
                    int i = 0;
                    while (i < fav791.length) {
                        fav791[i].fav79 = (byte)(fav791[i].fav79 ^ 1);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 65: {
                    Channel[] fav792 = Main.getSelected();
                    int i = 0;
                    while (i < fav792.length) {
                        fav792[i].fav79 = (byte)(fav792[i].fav79 ^ 2);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 66: {
                    Channel[] fav793 = Main.getSelected();
                    int i = 0;
                    while (i < fav793.length) {
                        fav793[i].fav79 = (byte)(fav793[i].fav79 ^ 4);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 67: {
                    Channel[] fav794 = Main.getSelected();
                    int i = 0;
                    while (i < fav794.length) {
                        fav794[i].fav79 = (byte)(fav794[i].fav79 ^ 8);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 127: {
                    try {
                        Desktop.getDesktop().browse(new URI("http://www.ullrich.es/job/sendersortierung/samsung-samygo/"));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                case 128: {
                    try {
                        Desktop.getDesktop().browse(new URI("http://www.hifi-forum.de/index.php?action=browseT&forum_id=151&thread=11695&postID=first#first"));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                case 129: {
                    new About();
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    private String selectFileToOpen(String message, String[] filter, String dir) {
        FileDialog fd = new FileDialog(this.shell, 4096);
        if (message != null) {
            fd.setText(message);
        }
        if (filter != null) {
            fd.setFilterExtensions(filter);
        }
        if (dir != null) {
            fd.setFilterPath(dir);
        }
        String path = fd.open();
        return path;
    }

    private String selectFileToSave(String message, String[] filter, String dir) {
        FileDialog fd = new FileDialog(this.shell, 8192);
        if (message != null) {
            fd.setText(message);
        }
        if (filter != null) {
            fd.setFilterExtensions(filter);
        }
        if (dir != null) {
            fd.setFilterPath(dir);
        }
        String path = fd.open();
        return path;
    }
}

