/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class SortListenerFactory
implements Listener {
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_TEXT = 1;
    private Comparator<TableItem> currentComparator = null;
    private int colIndex = 0;
    private int colType = 0;
    private int updown = -1;
    private Comparator<TableItem> Comparator = new Comparator<TableItem>(){

        @Override
        public int compare(TableItem t1, TableItem t2) {
            String v1 = t1.getText(SortListenerFactory.this.colIndex).toLowerCase();
            String v2 = t2.getText(SortListenerFactory.this.colIndex).toLowerCase();
            switch (SortListenerFactory.this.colType) {
                case 1: {
                    return v1.compareTo(v2) * SortListenerFactory.this.updown;
                }
            }
            return new Integer(t1.getText(SortListenerFactory.this.colIndex)).compareTo(Integer.parseInt(t2.getText(SortListenerFactory.this.colIndex))) * SortListenerFactory.this.updown;
        }
    };

    private SortListenerFactory() {
        this.currentComparator = this.Comparator;
    }

    public static Listener getListener() {
        return new SortListenerFactory();
    }

    public void handleEvent(Event e) {
        this.updown = this.updown == 1 ? -1 : 1;
        TableColumn currentColumn = (TableColumn)e.widget;
        Table table = currentColumn.getParent();
        this.colIndex = this.searchColumnIndex(currentColumn);
        this.colType = (Integer)currentColumn.getData("type");
        table.setRedraw(false);
        TableItem[] items = table.getItems();
        Arrays.sort(items, this.currentComparator);
        table.setItemCount(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = new TableItem(table, 0, i);
            item.setText(this.getData(items[i]));
            item.setData(items[i].getData());
            items[i].dispose();
            ++i;
        }
        table.setRedraw(true);
    }

    private String[] getData(TableItem t) {
        Table table = t.getParent();
        int colCount = table.getColumnCount();
        String[] s = new String[colCount];
        int i = 0;
        while (i < colCount) {
            s[i] = t.getText(i);
            ++i;
        }
        return s;
    }

    private int searchColumnIndex(TableColumn currentColumn) {
        Table table = currentColumn.getParent();
        int in = 0;
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getColumn(i) == currentColumn) {
                in = i;
            }
            ++i;
        }
        return in;
    }
}

