/*
 * Decompiled with CFR 0.152.
 */
package samyedit;

import gui.Main;
import samyedit.Channel;

public class AirCableChannel
extends Channel {
    public static final byte QAM64 = 1;
    public static final byte QAM256 = 2;
    public static final byte QAMauto = 8;
    public int recordLen = 292;
    byte[] rawData = new byte[320];
    public int iChanNo = 0;
    public int iChanVpid = 2;
    public int iChanMpid = 4;
    public int iChanSid = 6;
    public int iChanStatus = 8;
    public int iChanQam = 12;
    public int iChanSType = 15;
    public int iChanFav = 16;
    public int iChanEnc = 24;
    public int iChanSymbR = 28;
    public int iChanLock = 31;
    public int iChanONid = 32;
    public int iChanNid = 34;
    public int iChanBouqet = 36;
    public int iChanProvId = 38;
    public int iChanFreq = 42;
    public int iChanLcn = 44;
    public int iChanTSid = 48;
    public int iChanName = 64;
    public int lChanName = 100;
    public int iChanSName = 164;
    public int lChanSName = 9;
    public int iChanVFmt = 182;
    public int iChanFav79 = 290;
    public int iChanCRC = 291;
    public byte qam = 1;
    public int nid = -1;
    public int freq = -1;
    public int symbr = -1;
    public int lcn = 0;

    public int parse(int row, byte[] inData) {
        int size = inData.length / this.recordLen;
        if (row > size) {
            return 0;
        }
        int i = row;
        while (i < size) {
            int offset = i * this.recordLen;
            if (inData[offset] != 0) {
                byte chsum = 0;
                int j = 0;
                while (j < this.recordLen) {
                    this.rawData[j] = inData[offset + j];
                    chsum = (byte)(chsum + inData[offset + j]);
                    ++j;
                }
                this.num = AirCableChannel.convertEndianess(inData[offset + this.iChanNo], inData[offset + this.iChanNo + 1]);
                this.vpid = AirCableChannel.convertEndianess(inData[offset + this.iChanVpid], inData[offset + this.iChanVpid + 1]);
                this.mpid = AirCableChannel.convertEndianess(inData[offset + this.iChanMpid], inData[offset + this.iChanMpid + 1]);
                this.sid = AirCableChannel.convertEndianess(inData[offset + this.iChanSid], inData[offset + this.iChanSid + 1]);
                this.fav = inData[offset + this.iChanFav];
                this.status = inData[offset + this.iChanStatus];
                this.stype = inData[offset + this.iChanSType];
                this.qam = inData[offset + this.iChanQam];
                this.enc = inData[offset + this.iChanEnc];
                this.freq = AirCableChannel.convertEndianess(inData[offset + this.iChanFreq], inData[offset + this.iChanFreq + 1]);
                this.symbr = AirCableChannel.convertEndianess(inData[offset + this.iChanSymbR], inData[offset + this.iChanSymbR + 1]);
                this.lock = inData[offset + this.iChanLock];
                this.onid = AirCableChannel.convertEndianess(inData[offset + this.iChanONid], inData[offset + this.iChanONid + 1]);
                this.bouqet = AirCableChannel.convertEndianess(inData[offset + this.iChanBouqet], inData[offset + this.iChanBouqet + 1]);
                this.nid = AirCableChannel.convertEndianess(inData[offset + this.iChanNid], inData[offset + this.iChanNid + 1]);
                this.lcn = AirCableChannel.convertEndianess(inData[offset + this.iChanLcn], inData[offset + this.iChanLcn + 1]);
                this.tsid = AirCableChannel.convertEndianess(inData[offset + this.iChanTSid], inData[offset + this.iChanTSid + 1]);
                this.fav79 = inData[offset + this.iChanFav79];
                if (i == 0) {
                    Main.mapType = this.symbr != 0 ? (byte)1 : (byte)2;
                }
                j = 0;
                while (j < this.lChanName) {
                    int c = inData[offset + this.iChanName + 1 + j * 2];
                    if (c == 0) break;
                    if (c < 0) {
                        c += 256;
                    }
                    this.name = String.valueOf(this.name) + (char)c;
                    ++j;
                }
                return this.num;
            }
            ++i;
        }
        return 0;
    }

    public byte[] writeData() {
        AirCableChannel.revertEndianess(this.rawData, this.iChanNo, this.num);
        AirCableChannel.revertEndianess(this.rawData, this.iChanVpid, this.vpid);
        AirCableChannel.revertEndianess(this.rawData, this.iChanMpid, this.mpid);
        AirCableChannel.revertEndianess(this.rawData, this.iChanSid, this.sid);
        this.rawData[this.iChanFav] = this.fav;
        this.rawData[this.iChanQam] = this.qam;
        this.rawData[this.iChanStatus] = this.status;
        this.rawData[this.iChanSType] = this.stype;
        AirCableChannel.revertEndianess(this.rawData, this.iChanONid, this.onid);
        AirCableChannel.revertEndianess(this.rawData, this.iChanNid, this.nid);
        this.rawData[this.iChanEnc] = this.enc;
        AirCableChannel.revertEndianess(this.rawData, this.iChanFreq, this.freq);
        AirCableChannel.revertEndianess(this.rawData, this.iChanLcn, this.lcn);
        AirCableChannel.revertEndianess(this.rawData, this.iChanSymbR, this.symbr);
        AirCableChannel.revertEndianess(this.rawData, this.iChanBouqet, this.bouqet);
        AirCableChannel.revertEndianess(this.rawData, this.iChanTSid, this.tsid);
        char[] name = this.name.toCharArray();
        int n = 0;
        while (n < name.length) {
            this.rawData[this.iChanName + 1 + 2 * n] = (byte)name[n];
            ++n;
        }
        while (n < this.lChanName) {
            this.rawData[this.iChanName + 1 + 2 * n] = 0;
            ++n;
        }
        this.rawData[this.iChanLock] = this.lock;
        this.rawData[this.iChanFav79] = this.fav79;
        this.rawData[this.iChanCRC] = 0;
        int i = 0;
        while (i < this.iChanCRC) {
            int n2 = this.iChanCRC;
            this.rawData[n2] = (byte)(this.rawData[n2] + this.rawData[i]);
            ++i;
        }
        return this.rawData;
    }

    public String getFreq() {
        if (this.freq < 7) {
            return "S" + new Integer(this.freq + 4).toString();
        }
        if (this.freq < 15) {
            return "K" + new Integer(this.freq - 2).toString();
        }
        if (this.freq < 46) {
            return "S" + new Integer(this.freq - 4).toString();
        }
        if (this.freq < 95) {
            return "K" + new Integer(this.freq - 25).toString();
        }
        if (this.freq < 194) {
            return "!" + new Integer(this.freq).toString();
        }
        if (this.freq < 196) {
            return "S" + new Integer(this.freq - 192).toString();
        }
        return "?" + new Integer(this.freq).toString();
    }

    public int setFreq(String s) {
        String fStr = s.substring(1);
        int f = Integer.parseInt(fStr);
        if (s.startsWith("S") && f < 4) {
            this.freq = f + 192;
            return this.freq;
        }
        if (s.startsWith("S") && f < 11) {
            this.freq = f - 4;
            return this.freq;
        }
        if (s.startsWith("S") && f < 42) {
            this.freq = f + 4;
            return this.freq;
        }
        if (s.startsWith("K") && f < 13) {
            this.freq = f + 2;
            return this.freq;
        }
        if (s.startsWith("K") && f < 70) {
            this.freq = f + 25;
            return this.freq;
        }
        if (s.startsWith("!") && f < 194) {
            this.freq = f + 0;
            return this.freq;
        }
        this.freq = Integer.parseInt(s);
        return this.freq;
    }
}

