/*
 * Decompiled with CFR 0.152.
 */
package samyedit;

import gui.ErrorMessage;
import gui.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeMap;
import samyedit.AirCableChannel;
import samyedit.AirCableChannelC;
import samyedit.AirCableChannelD;
import samyedit.Channel;
import samyedit.CloneChannel;
import samyedit.SatChannel;
import samyedit.SatChannelC;
import samyedit.SatChannelD;

public class MapParser {
    public MapParser(String path, TreeMap<Integer, Channel> channelList) {
        if (path.endsWith("map-AirD") || path.endsWith("map-CableD")) {
            Main.mapType = 1;
            MapParser.parseAirCable(path, channelList);
            Main.table.setRedraw(false);
            Main.deleteColumns();
            if (Main.mapType == 2) {
                Main.createColumnsAir();
            } else {
                Main.createColumnsCable();
            }
            Main.table.setRedraw(true);
        } else if (path.endsWith("map-SateD")) {
            switch (Main.scmVersion) {
                case 'C': 
                case 'D': {
                    Main.mapType = (byte)4;
                    this.parseSat(path, channelList);
                    Main.table.setRedraw(false);
                    Main.deleteColumns();
                    Main.createColumnsSat();
                    Main.table.setRedraw(true);
                    break;
                }
                default: {
                    new ErrorMessage("Function not implemented for " + Main.scmVersion + "-Series file: " + path);
                    break;
                }
            }
        } else if (path.endsWith("clon.bin")) {
            Main.mapType = (byte)8;
            this.parseClone(path, channelList);
            Main.table.setRedraw(false);
            Main.deleteColumns();
            Main.createColumnsClone();
            Main.table.setRedraw(true);
        } else {
            new ErrorMessage("Function not implemented for files with name: " + path);
        }
        Main.statusLabel.setText("");
    }

    public static void parseAirCable(String path, TreeMap<Integer, Channel> channelList) {
        byte[] rawData;
        try {
            rawData = MapParser.getFileContentsAsBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int row = 0;
        AirCableChannel chan = null;
        do {
            switch (Main.scmVersion) {
                case 'C': {
                    chan = new AirCableChannelC();
                    break;
                }
                case 'D': {
                    chan = new AirCableChannelD();
                    break;
                }
                default: {
                    new ErrorMessage("Function not implemented for " + Main.scmVersion + "-Series TV");
                    return;
                }
            }
            if (chan.parse(row++, rawData) <= 0) break;
            channelList.put(chan.num, chan);
        } while (row > 0);
    }

    private void parseSat(String path, TreeMap<Integer, Channel> channelList) {
        byte[] rawData;
        try {
            rawData = MapParser.getFileContentsAsBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int row = 0;
        SatChannel chan = null;
        do {
            switch (Main.scmVersion) {
                case 'C': {
                    chan = new SatChannelC();
                    break;
                }
                case 'D': {
                    chan = new SatChannelD();
                    break;
                }
                default: {
                    new ErrorMessage("Function not implemented for " + Main.scmVersion + "-Series TV");
                    return;
                }
            }
            if (chan.parse(row++, rawData) <= 0) break;
            channelList.put(chan.num, chan);
        } while (row > 0);
    }

    private void parseClone(String path, TreeMap<Integer, Channel> channelList) {
        byte[] rawData;
        try {
            rawData = MapParser.getFileContentsAsBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Main.mapType = (byte)8;
        Main.rawData = rawData;
        int size = MapParser.convertEndianess(rawData[92658], rawData[92657]);
        int i = 0;
        while (i < size) {
            int offset = 4930 + i * 81;
            System.out.println(rawData[offset + 73]);
            if ((rawData[offset + 73] & 0x20) != 32) {
                CloneChannel chan = new CloneChannel();
                int j = 0;
                while (j < 81) {
                    chan.rawData[j] = rawData[offset + j];
                    ++j;
                }
                j = 0;
                while (j < 50) {
                    int c = rawData[offset + j];
                    if (c == 0) break;
                    if (c < 0) {
                        c += 256;
                    }
                    chan.name = String.valueOf(chan.name) + (char)c;
                    ++j;
                }
                chan.num = MapParser.convertEndianess(rawData[offset + 51], rawData[offset + 50]);
                chan.vpid = MapParser.convertEndianess(rawData[offset + 53], rawData[offset + 52]);
                chan.mpid = MapParser.convertEndianess(rawData[offset + 55], rawData[offset + 54]);
                chan.freq = rawData[offset + 56];
                chan.fav = rawData[offset + 57];
                chan.nid = MapParser.convertEndianess(rawData[offset + 60], rawData[offset + 59]);
                chan.tsid = MapParser.convertEndianess(rawData[offset + 62], rawData[offset + 61]);
                chan.onid = MapParser.convertEndianess(rawData[offset + 64], rawData[offset + 63]);
                chan.sid = MapParser.convertEndianess(rawData[offset + 66], rawData[offset + 65]);
                chan.stype = rawData[offset + 71];
                chan.enc = rawData[offset + 73];
                channelList.put(chan.num, chan);
            }
            ++i;
        }
    }

    public static void write(String file, TreeMap<Integer, Channel> channelList) {
        switch (Main.mapType) {
            case 1: 
            case 2: {
                MapParser.writeAirCable(file, channelList);
                break;
            }
            case 4: {
                MapParser.writeSat(file, channelList);
                break;
            }
            case 8: {
                MapParser.writeClone(file, channelList);
            }
        }
    }

    public static void writeClone(String file, TreeMap<Integer, Channel> channelList) {
        FileOutputStream outStream;
        Iterator<Channel> it = channelList.values().iterator();
        File f = new File(file);
        try {
            outStream = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            new ErrorMessage("Cannot write to file:\n" + e.getMessage());
            Main.statusLabel.setText("");
            return;
        }
        try {
            ((OutputStream)outStream).write(Main.rawData, 0, 4930);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int entries = 0;
        while (it.hasNext() && entries < 999) {
            CloneChannel chan = (CloneChannel)it.next();
            byte[] rawData = chan.rawData;
            char[] name = chan.name.toCharArray();
            int n = 0;
            while (n < name.length && n < 50) {
                rawData[n] = (byte)name[n];
                ++n;
            }
            rawData[75] = (byte)n;
            while (n < 50) {
                rawData[n] = 0;
                ++n;
            }
            MapParser.revertClone(rawData, 50, chan.num);
            MapParser.revertClone(rawData, 52, chan.vpid);
            MapParser.revertClone(rawData, 54, chan.mpid);
            rawData[56] = (byte)chan.freq;
            rawData[57] = chan.fav;
            MapParser.revertClone(rawData, 59, chan.nid);
            MapParser.revertClone(rawData, 61, chan.tsid);
            MapParser.revertClone(rawData, 63, chan.onid);
            MapParser.revertClone(rawData, 65, chan.sid);
            rawData[71] = chan.stype;
            rawData[73] = chan.enc;
            try {
                ((OutputStream)outStream).write(rawData);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
        }
        System.out.println(entries);
        MapParser.revertClone(Main.rawData, 92654, entries);
        MapParser.revertClone(Main.rawData, 92657, entries);
        byte[] rawData = new byte[81];
        int i = 0;
        while (i < 81) {
            rawData[i] = -1;
            ++i;
        }
        while (entries < 999) {
            try {
                ((OutputStream)outStream).write(rawData);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
        }
        try {
            ((OutputStream)outStream).write(Main.rawData, 85849, 29863);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Main.statusLabel.setText("Channel list written to file: " + file);
    }

    /*
     * Unable to fully structure code
     */
    public static void writeAirCable(String file, TreeMap<Integer, Channel> channelList) {
        it = channelList.values().iterator();
        f = new File(file);
        try {
            outStream = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            new ErrorMessage("Cannot write to file:\n" + e.getMessage());
            Main.statusLabel.setText("");
            return;
        }
        entries = 0;
        recordLen = 0;
        switch (Main.scmVersion) {
            case 'C': {
                recordLen = 292;
                ** GOTO lbl32
            }
            case 'D': {
                recordLen = 320;
                if (true) ** GOTO lbl32
            }
            default: {
                new ErrorMessage("Function not implemented for " + Main.scmVersion + "-Series TV");
                return;
            }
        }
        do {
            chan = (AirCableChannel)it.next();
            rawData = chan.writeData();
            try {
                outStream.write(rawData, 0, recordLen);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
lbl32:
            // 3 sources

        } while (it.hasNext());
        rawData = new byte[recordLen];
        while (entries % 1000 != 0) {
            try {
                outStream.write(rawData, 0, recordLen);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
        }
        Main.statusLabel.setText("Channel list written to file: " + file);
    }

    /*
     * Unable to fully structure code
     */
    public static void writeSat(String file, TreeMap<Integer, Channel> channelList) {
        it = channelList.values().iterator();
        f = new File(file);
        try {
            outStream = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            new ErrorMessage("Cannot write to file:\n" + e.getMessage());
            Main.statusLabel.setText("");
            return;
        }
        entries = 0;
        recordLen = 0;
        switch (Main.scmVersion) {
            case 'C': {
                recordLen = SatChannelC.lChan;
                ** GOTO lbl32
            }
            case 'D': {
                recordLen = SatChannelD.lChan;
                if (true) ** GOTO lbl32
            }
            default: {
                new ErrorMessage("Function not implemented for " + Main.scmVersion + "-Series TV");
                return;
            }
        }
        do {
            chan = (SatChannel)it.next();
            rawData = chan.writeData();
            try {
                outStream.write(rawData, 0, recordLen);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
lbl32:
            // 3 sources

        } while (it.hasNext());
        Main.statusLabel.setText("Channel list written to file: " + file);
    }

    private static int convertEndianess(byte b, byte c) {
        int lower = b;
        int upper = c;
        if (b < 0) {
            lower += 256;
        }
        if (c < 0) {
            upper += 256;
        }
        return lower + (upper << 8);
    }

    private static void revertClone(byte[] b, int offset, int data) {
        b[offset + 1] = (byte)data;
        b[offset] = (byte)(data >> 8);
    }

    public static byte[] getFileContentsAsBytes(String file) throws IOException {
        File f = new File(file);
        byte[] data = new byte[(int)f.length()];
        FileInputStream inStream = new FileInputStream(f);
        ((InputStream)inStream).read(data);
        ((InputStream)inStream).close();
        return data;
    }
}

